function getURLVar(key) {
	var value = [];

	var query = String(document.location).split('?');

	if (query[1]) {
		var part = query[1].split('&');

		for (i = 0; i < part.length; i++) {
			var data = part[i].split('=');

			if (data[0] && data[1]) {
				value[data[0]] = data[1];
			}
		}

		if (value[key]) {
			return value[key];
		} else {
			return '';
		}
	}
}

function getTitle(information_id) {
	$('#information-title-content-' + information_id).load('index.php?route=editors/catalog_edit/getInformationTitle&user_token=' + getURLVar('user_token') + '&information_id=' + information_id);
}

function editSort(information_id) {
	var sort_order = $('#input-sort' + information_id).val();
	var type = 'information_sort_order';
							
	$.ajax({
		url: 'index.php?route=editors/catalog_edit/catalog&user_token=' + getURLVar('user_token') + '&information_id=' + information_id + '&sort_order=' + sort_order + '&type=' + type,
		type: 'post',
		dataType: 'json',
		success: function(json) {									
			if (json['error']) {								
				$('.messages-body').html('<div class="alert alert-danger alert-messages"><i class="fa fa-check-circle"></i> ' + json['error'] + '</div>');$('.maxy-backdrop, .messages-body').show().delay(1500).fadeOut(500);
			}
									
			if (json['success']) {
				$('.messages-body').html('<div class="alert alert-success alert-messages"><i class="fa fa-check-circle"></i> ' + json['success'] + '</div>');$('.maxy-backdrop, .messages-body').show().delay(1000).fadeOut(500);			
				
				if (sort_order != '') {
					$('#information-sort' + information_id).html(sort_order);
				} else {
					$('#information-sort' + information_id).html('0');
				}

				$('#close-sort-' + information_id).trigger('click');
			}
		}
	});
}

function sortClear(information_id) {
	$('#input-sort' + information_id).val('');
}

function editButtons(information_id, type) {
	var value_data = '';
	
	if (type == 'bottom') {
		var bottom = $('#information-bottom-' + information_id).find('input[name=\'bottoms\']').val();
	} else if (type == 'information_status') {
		var status = $('#information-status-' + information_id).find('input[name=\'statuses\']').val();
	}
	
	if (bottom == 0 || status == 0) {
		value_data = 1;
	} else {
		value_data = 0;
	}
	
	$.ajax({
		url: 'index.php?route=editors/catalog_edit/catalog&user_token=' + getURLVar('user_token') + '&information_id=' + information_id + '&type=' + type + '&value_data=' + value_data,
		type: 'post',
		dataType: 'json',
		success: function(json) {
			if (json['error']) {
				$('.messages-body').html('<div class="alert alert-danger alert-messages"><i class="fa fa-check-circle"></i> ' + json['error'] + '</div>');$('.maxy-backdrop, .messages-body').show().delay(1500).fadeOut(500);
			}

			if (json['success']) {
				if (type == 'bottom') {
					if (bottom == 0) {
						$('#bottom-' + information_id).html('<span class="btn btn-info btn-sm"><i class="fa fa-check-circle"></i></span>');
						$('#information-bottom-' + information_id).find('input[name=\'bottoms\']').val('1');
					} else {
						$('#bottom-' + information_id).html('<span class="btn btn-warning btn-sm"><i class="fa fa-power-off"></i></span>');
						$('#information-bottom-' + information_id).find('input[name=\'bottoms\']').val('0');
					}
				} else if (type == 'information_status') {
					if (status == 0) {
						$('#status-' + information_id).html('<span class="btn btn-success btn-sm"><i class="fa fa-check-circle"></i></span>');
						$('#information-status-' + information_id).find('input[name=\'statuses\']').val('1');
					} else {
						$('#status-' + information_id).html('<span class="btn btn-danger btn-sm"><i class="fa fa-power-off"></i></span>');
						$('#information-status-' + information_id).find('input[name=\'statuses\']').val('0');
					}
				}
			}
		},
		error: function(xhr, ajaxOptions, thrownError) {
			alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
		}
	});	
}

function editMore(information_id, val) {	
	$('#information-more-' + information_id).popoverMaxy('hide');
	$('#modal-information-edit').modal('show');
		
	$('#modal-information-edit').on('hide.bs.modal', function() {
		$('#modal-information-content').empty();
	});
	
	$('#modal-information-content').load('index.php?route=editors/catalog_edit/edit_information_' + val + '&user_token=' + getURLVar('user_token') + '&information_id=' + information_id);
}